/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common.statuses;

import com.ibm.asyncutil.util.Either;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.config.ModStatuses;
import com.ishland.c2me.base.common.registry.SerializerAccess;
import com.ishland.c2me.base.common.theinterface.IDirectStorage;
import com.ishland.c2me.base.common.threadstate.RunningWork;
import com.ishland.c2me.base.common.threadstate.ThreadInstrumentation;
import com.ishland.c2me.base.common.threadstate.ThreadState;
import com.ishland.c2me.base.common.util.RxJavaUtils;
import com.ishland.c2me.base.mixin.access.IServerLightingProvider;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.base.mixin.access.IVersionedChunkStorage;
import com.ishland.c2me.base.mixin.access.IWorldChunk;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkLoadingContext;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkState;
import com.ishland.c2me.rewrites.chunksystem.common.Config;
import com.ishland.c2me.rewrites.chunksystem.common.NewChunkHolderVanillaInterface;
import com.ishland.c2me.rewrites.chunksystem.common.NewChunkStatus;
import com.ishland.c2me.rewrites.chunksystem.common.async_chunkio.BlendingInfoUtil;
import com.ishland.c2me.rewrites.chunksystem.common.async_chunkio.ProtoChunkExtension;
import com.ishland.c2me.rewrites.chunksystem.common.ducks.IPOIUnloading;
import com.ishland.c2me.rewrites.chunksystem.common.fapi.LifecycleEventInvoker;
import com.ishland.c2me.rewrites.chunksystem.common.threadstate.ChunkTaskWork;
import com.ishland.flowsched.scheduler.Cancellable;
import com.ishland.flowsched.scheduler.ItemHolder;
import com.ishland.flowsched.scheduler.KeyStatusPair;
import com.ishland.flowsched.util.Assertions;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_11897;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2808;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFromDisk
extends NewChunkStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ReadFromDisk");

    public ReadFromDisk(int ordinal) {
        super(ordinal, class_2806.field_12798);
    }

    public Completable upgradeToThis(ChunkLoadingContext context, Cancellable cancellable) {
        Single single = this.invokeVanillaLoad(context).retryWhen(RxJavaUtils.retryWithExponentialBackoff((int)5, (long)100L, (Throwable[])new Throwable[0]));
        return this.finalizeLoading(context, (Single<class_2839>)single);
    }

    @NotNull
    protected Completable finalizeLoading(ChunkLoadingContext context, Single<class_2839> single) {
        return single.doOnError(throwable -> {
            MinecraftServer server = ((IThreadedAnvilChunkStorage)context.tacs()).getWorld().method_8503();
            server.execute(() -> server.method_57821(throwable, ((IVersionedChunkStorage)context.tacs()).invokeGetStorageKey(), (class_1923)context.holder().getKey()));
        }).onErrorResumeNext(throwable -> {
            if (Config.recoverFromErrors) {
                return Single.just((Object)this.createEmptyProtoChunk(context));
            }
            return Single.error((Throwable)throwable);
        }).doOnSuccess(chunk -> {
            context.holder().getItem().set(new ChunkState((class_2791)chunk, (class_2839)chunk, class_2806.field_12798));
            if (!Config.lowMemoryMode) {
                ((NewChunkHolderVanillaInterface)((Object)((Object)context.holder().getUserData().get()))).triggerDeferredLoad(NewChunkStatus.DISK);
            }
        }).ignoreElement().cache();
    }

    @NonNull
    protected Single<class_2839> invokeVanillaLoad(ChunkLoadingContext context) {
        return this.invokeInitialChunkRead(context).observeOn(Schedulers.from((Executor)((IThreadedAnvilChunkStorage)context.tacs()).getMainThreadExecutor())).map(chunkSerializer -> {
            Assertions.assertTrue((boolean)((IThreadedAnvilChunkStorage)context.tacs()).getMainThreadExecutor().method_18854());
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
                if (chunkSerializer.isPresent()) {
                    class_2839 class_28392 = ((class_2852)chunkSerializer.get()).method_12395(((IThreadedAnvilChunkStorage)context.tacs()).getWorld(), ((IThreadedAnvilChunkStorage)context.tacs()).getPointOfInterestStorage(), ((IVersionedChunkStorage)context.tacs()).invokeGetStorageKey(), (class_1923)context.holder().getKey());
                    return class_28392;
                }
                class_2839 class_28393 = this.createEmptyProtoChunk(context);
                return class_28393;
            }
        }).flatMap(protoChunk -> this.postChunkLoading(context, (class_2839)protoChunk).toSingleDefault(protoChunk));
    }

    @NotNull
    protected Completable postChunkLoading(ChunkLoadingContext context, class_2839 protoChunk) {
        try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
            class_3218 world = ((IThreadedAnvilChunkStorage)context.tacs()).getWorld();
            class_1923 pos = (class_1923)context.holder().getKey();
            class_2839 class_28392 = protoChunk = protoChunk != null ? protoChunk : new class_2839(pos, class_2843.field_12950, (class_5539)world, world.method_74142(), null);
            if (protoChunk.method_39300() != null || protoChunk.method_12009().method_12164() == class_2808.field_12808) {
                class_2839 finalProtoChunk = protoChunk;
                Completable completable = Single.defer(() -> Single.fromCompletionStage(BlendingInfoUtil.getBlendingInfos(((IVersionedChunkStorage)context.tacs()).getWorker(), pos))).doOnSuccess(bitSets -> ((ProtoChunkExtension)finalProtoChunk).setBlendingInfo(pos, (List<BitSet>)bitSets)).ignoreElement();
                return completable;
            }
            Completable completable = Completable.complete();
            return completable;
        }
    }

    @NotNull
    protected Single<Optional<class_2852>> invokeInitialChunkRead(ChunkLoadingContext context) {
        return Single.defer(() -> Single.fromCompletionStage((CompletionStage)((IThreadedAnvilChunkStorage)context.tacs()).invokeGetUpdatedChunkNbt((class_1923)context.holder().getKey()))).map(optional -> optional.map(nbtCompound -> {
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
                class_3218 world = ((IThreadedAnvilChunkStorage)context.tacs()).getWorld();
                class_2852 chunkSerializer = class_2852.method_61794((class_5539)world, (class_11897)world.method_74142(), (class_2487)nbtCompound);
                if (chunkSerializer == null) {
                    LOGGER.error("Chunk file at {} is missing level data, skipping", context.holder().getKey());
                }
                class_2852 class_28522 = chunkSerializer;
                return class_28522;
            }
        })).zipWith((SingleSource)Completable.defer(() -> Completable.fromCompletionStage((CompletionStage)((IThreadedAnvilChunkStorage)context.tacs()).getPointOfInterestStorage().method_61780((class_1923)context.holder().getKey()))).toSingleDefault(ReadFromDisk.class), (chunkSerializer, o) -> chunkSerializer);
    }

    @NotNull
    protected class_2839 createEmptyProtoChunk(ChunkLoadingContext context) {
        try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
            class_3218 world = ((IThreadedAnvilChunkStorage)context.tacs()).getWorld();
            class_2839 class_28392 = new class_2839((class_1923)context.holder().getKey(), class_2843.field_12950, (class_5539)world, world.method_74142(), null);
            return class_28392;
        }
    }

    public Completable postUpgradeToThis(ChunkLoadingContext context) {
        return Completable.complete();
    }

    public Completable preDowngradeFromThis(ChunkLoadingContext context, Cancellable cancellable) {
        return Completable.defer(() -> Completable.fromCompletionStage(this.syncWithLightEngine(context))).observeOn(Schedulers.from((Executor)((IThreadedAnvilChunkStorage)context.tacs()).getMainThreadExecutor())).andThen(observer -> {
            if (context.holder().getTargetStatus().ordinal() > this.ordinal()) {
                cancellable.cancel();
                observer.onError((Throwable)new CancellationException());
            } else {
                observer.onComplete();
            }
        });
    }

    public Completable downgradeFromThis(ChunkLoadingContext context, Cancellable cancellable) {
        AtomicBoolean loadedToWorld = new AtomicBoolean(false);
        return Completable.defer(() -> {
            Assertions.assertTrue((boolean)((IThreadedAnvilChunkStorage)context.tacs()).getMainThreadExecutor().method_18854());
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, false));){
                Completable asyncSaveFuture;
                class_2818 worldChunk;
                ChunkState chunkState = (ChunkState)context.holder().getItem().get();
                class_2791 chunk = chunkState.chunk();
                if (chunk instanceof class_2821) {
                    class_2821 protoChunk = (class_2821)chunk;
                    chunk = protoChunk.method_12240();
                }
                if (chunk instanceof class_2818) {
                    worldChunk = (class_2818)chunk;
                    loadedToWorld.set(((IWorldChunk)worldChunk).isLoadedToWorld());
                    worldChunk.method_12226(false);
                }
                if (loadedToWorld.get() && ModStatuses.fabric_lifecycle_events_v1 && chunk instanceof class_2818) {
                    worldChunk = (class_2818)chunk;
                    LifecycleEventInvoker.invokeChunkUnload(((IThreadedAnvilChunkStorage)context.tacs()).getWorld(), worldChunk);
                }
                if ((context.holder().getFlags() & 2) != 0 && chunk instanceof class_2839) {
                    LOGGER.warn("Not saving partially generated broken chunk {}", context.holder().getKey());
                    asyncSaveFuture = Completable.complete();
                } else {
                    asyncSaveFuture = chunk instanceof class_2818 && !chunkState.reachedStatus().method_12165(class_2806.field_12803) ? Completable.complete() : this.asyncSave(context, chunk);
                }
                if (loadedToWorld.get() && chunk instanceof class_2818) {
                    class_2818 worldChunk2 = (class_2818)chunk;
                    ((IThreadedAnvilChunkStorage)context.tacs()).getWorld().method_18764(worldChunk2);
                }
                ((IServerLightingProvider)((IThreadedAnvilChunkStorage)context.tacs()).getLightingProvider()).invokeUpdateChunkStatus(chunk.method_12004());
                ((IThreadedAnvilChunkStorage)context.tacs()).getLightingProvider().method_17303();
                ((IThreadedAnvilChunkStorage)context.tacs()).getChunkToNextSaveTimeMs().remove(chunk.method_12004().method_8324());
                ((IPOIUnloading)((IThreadedAnvilChunkStorage)context.tacs()).getPointOfInterestStorage()).c2me$unloadPoi((class_1923)context.holder().getKey());
                context.holder().getItem().set(new ChunkState(null, null, null));
                Completable completable = asyncSaveFuture;
                return completable;
            }
        });
    }

    private Completable asyncSave(ChunkLoadingContext context, class_2791 chunk) {
        ((IThreadedAnvilChunkStorage)context.tacs()).getPointOfInterestStorage().method_20436(chunk.method_12004());
        if (!chunk.method_65064()) {
            return Completable.complete();
        }
        class_1923 chunkPos = chunk.method_12004();
        class_2852 serializer = class_2852.method_61793((class_3218)((IThreadedAnvilChunkStorage)context.tacs()).getWorld(), (class_2791)chunk);
        return Single.fromCallable(() -> {
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, false));){
                Either either = SerializerAccess.getSerializer().serialize(serializer);
                return either;
            }
        }).subscribeOn(Schedulers.from((Executor)GlobalExecutors.prioritizedScheduler.executor(16))).flatMapCompletable(either -> {
            if (either.left().isPresent()) {
                class_2487 nbtCompound = (class_2487)either.left().get();
                return Completable.fromCompletionStage((CompletionStage)context.tacs().method_17910(chunkPos, () -> nbtCompound));
            }
            return Completable.fromCompletionStage((CompletionStage)((IDirectStorage)((IVersionedChunkStorage)context.tacs()).getWorker()).setRawChunkData(chunkPos, (byte[])either.right().get()));
        });
    }

    protected CompletionStage<?> syncWithLightEngine(ChunkLoadingContext context) {
        return ((IThreadedAnvilChunkStorage)context.tacs()).getLightingProvider().method_53694(((class_1923)context.holder().getKey()).field_9181, ((class_1923)context.holder().getKey()).field_9180);
    }

    public String toString() {
        return "minecraft:empty";
    }

    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependenciesToRemove(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        return EMPTY_DEPENDENCIES;
    }

    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependenciesToAdd(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        return EMPTY_DEPENDENCIES;
    }
}

